/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class Utilities {
    public static StringBuffer buffer = new StringBuffer();
    public static final String ERROR_ID_ALREADY_VDS_CONFIRMED = "XP-ERR-040";
    public static final String ERROR_ID_APPLET_OVERTAKEN = "XP-ERR-025";
    public static final String ERROR_ID_ASSESSMENT_COMPLETE = "XP-ERR-026";
    public static final String ERROR_ID_ASSESSMENT_END_REDIRECT_ERROR = "XP-ERR-043";
    public static final String ERROR_ID_AUTHENTICATION_FAILURE_REDIRECTION = "XP-ERR-033";
    public static final String ERROR_ID_AUTHENTICATION_REDIRECT = "XP-ERR-042";
    public static final String ERROR_ID_BROWSER_NAME = "XP-ERR-029";
    public static final String ERROR_ID_COMPLETION = "XP-ERR-044";
    public static final String ERROR_ID_EMERGENCY = "XP-ERR-001";
    public static final String ERROR_ID_GET_SESSION_INFO = "XP-ERR-041";
    public static final String ERROR_ID_GET_SESSION_XML = "XP-ERR-024";
    public static final String ERROR_ID_HIGHER_MINIMUM_PT_VERSION_ERROR = "XP-ERR-027";
    public static final String ERROR_ID_INTERNAL_ASSESSMENT_UNSUPPORTED = "XP-ERR-031";
    public static final String ERROR_ID_IPC_ERROR = "XP-ERR-002";
    public static final String ERROR_ID_JRE_VERSION = "XP-ERR-003";
    public static final String ERROR_ID_NESTED_ERROR = "XP-ERR-001";
    public static final String ERROR_ID_NO_IPC_PORT = "XP-ERR-004";
    public static final String ERROR_ID_NO_PACKET_TRACER = "XP-ERR-005";
    public static final String ERROR_ID_NO_PKA = "XP-ERR-017";
    public static final String ERROR_ID_NO_PTA_FILE = "XP-ERR-008";
    public static final String ERROR_ID_NO_SECURITY_ACCESS = "XP-ERR-006";
    public static final String ERROR_ID_NO_SESSION_ID = "XP-ERR-032";
    public static final String ERROR_ID_PACKET_TRACER_SCORING = "XP-ERR-037";
    public static final String ERROR_ID_PARAMETER_PROCESSING = "XP-ERR-007";
    public static final String ERROR_ID_PKA_ACCESS = "XP-ERR-038";
    public static final String ERROR_ID_PKA_VERSION = "XP-ERR-022";
    public static final String ERROR_ID_PTA_MISSING = "XP-ERR-008";
    public static final String ERROR_ID_PTA_PLAYER_INITIALIZATION = "XP-ERR-020";
    public static final String ERROR_ID_PTA_PLAYER_JAR = "XP-ERR-009";
    public static final String ERROR_ID_PTA_PLAYER_JAR_LOADING = "XP-ERR-021";
    public static final String ERROR_ID_PTA_PLAYER_PATCH_FILES = "XP-ERR-019";
    public static final String ERROR_ID_PT_CLOSED = "XP-ERR-034";
    public static final String ERROR_ID_PT_CONNECT_TIME_OUT = "XP-ERR-010";
    public static final String ERROR_ID_PT_LAUNCH = "XP-ERR-011";
    public static final String ERROR_ID_PT_VERSION_PROBLEM = "XP-ERR-012";
    public static final String ERROR_ID_PT_VERSION_REDUCED_ERROR = "XP-ERR-028";
    public static final String ERROR_ID_PUT_SESSION_XML = "XP-ERR-035";
    public static final String ERROR_ID_SAVE_XML_CREATION = "XP-ERR-013";
    public static final String ERROR_ID_SAVE_XML_POSTING = "XP-ERR-014";
    public static final String ERROR_ID_SERVER_SIDE_JAVA = "XP-ERR-023";
    public static final String ERROR_ID_SUBMISSION = "XP-ERR-015";
    public static final String ERROR_ID_UNKNOWN_ERROR = "XP-ERR-000";
    public static final String ERROR_ID_UNKNOWN_JAVA_ERROR = "XP-ERR-016";
    public static final String ERROR_ID_UNRECOGNIZED_ASSESSMENT = "XP-ERR-030";
    public static final String ERROR_ID_XPASS_SCORING = "XP-ERR-039";
    public static final String ERROR_ID_XPASS_UNAVAILABLE = "XP-ERR-036";
    public static final String PT_ENVIRONMENT_VARIABLES = "PT6HOME,PT5HOME,PT_LAUNCH_DIR,PTDIR";
    public static final String PT_WINDOWS_DIRECTORIES = "C:\\Program Files\\Packet Tracer 6.0,C:\\Program Files (x86)\\Packet Tracer 6.0,C:\\Program Files\\Packet Tracer 5.3.3,C:\\Program Files (x86)\\Packet Tracer 5.3.3,C:\\Program Files\\Packet Tracer 5.3.2,C:\\Program Files (x86)\\Packet Tracer 5.3.2";
    public static String PTA_PLAYER_FEATURES = "";
    public static final int DEFAULT_IO_BUFFER_SIZE = 64000;
    public static final int DEFAULT_NUMBER_OF_DOWNLOAD_TRIES = 5;
    public static final String JRE_VERSIONS_SEPARATOR = ";";
    public static final String NO_KNOWN_BUILD_VERSION = "Unknown (Jackrabbit007 or earlier)";
    public static final String PATCH_FILES_SEPARATOR = ",";
    public static String[] NAMES = new String[]{"java.version", "java.vm.specification.version", "java.specification.version", "java.vm.version"};

    public static byte[] byteSubArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[n + i];
        }
        return byArray2;
    }

    public static long calculateCheckSum(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }

    public static void check(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
    }

    public static void checkIgnore(Throwable throwable) {
        Utilities.check(throwable);
        Utilities.ignore(throwable);
    }

    public static void checkSwallow(Throwable throwable) {
        Utilities.check(throwable);
        Utilities.swallow(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws Exception {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            Utilities.copy(fileInputStream, fileOutputStream, false);
        }
        catch (Throwable throwable) {
            Utilities.safeClose(fileInputStream);
            Utilities.safeClose(fileOutputStream);
            throw throwable;
        }
        Utilities.safeClose(fileInputStream);
        Utilities.safeClose(fileOutputStream);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws Exception {
        Utilities.copy(inputStream, outputStream, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, boolean bl) throws Exception {
        int n = 0;
        byte[] byArray = new byte[1500000];
        while ((n = inputStream.read(byArray, 0, 1500000)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        if (bl) {
            inputStream.close();
            outputStream.close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, ProgressMonitor progressMonitor, int n) throws Exception {
        Utilities.copy(inputStream, outputStream, progressMonitor, n, true);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, ProgressMonitor progressMonitor, int n, boolean bl) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[5000];
        int n3 = n;
        while ((n2 = inputStream.read(byArray, 0, 5000)) != -1) {
            outputStream.write(byArray, 0, n2);
            progressMonitor.setProgress(n3 += n2);
        }
        outputStream.flush();
        if (bl) {
            inputStream.close();
            outputStream.close();
        }
    }

    public static byte[] downloadBytes(URL uRL) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.addRequestProperty("content-type", "application/x-chunk");
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        Object object = uRLConnection.getContent();
        String string = uRLConnection.getContentEncoding();
        int n = uRLConnection.getContentLength();
        String string2 = uRLConnection.getContentType();
        InputStream inputStream = uRLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utilities.copy(inputStream, byteArrayOutputStream, true);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] downloadBytes(URL uRL, ProgressMonitor progressMonitor, int n) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.addRequestProperty("content-type", "application/x-chunk");
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        Object object = uRLConnection.getContent();
        String string = uRLConnection.getContentEncoding();
        int n2 = uRLConnection.getContentLength();
        String string2 = uRLConnection.getContentType();
        InputStream inputStream = uRLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utilities.copy(inputStream, byteArrayOutputStream, progressMonitor, n, true);
        return byteArrayOutputStream.toByteArray();
    }

    public static File downloadFile(URL uRL) throws Exception {
        File file = File.createTempFile("download", "jar");
        Utilities.downloadFile(uRL, file);
        return file;
    }

    public static void downloadFile(URL uRL, File file) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Utilities.copy(inputStream, fileOutputStream, true);
    }

    public static String getBuildId() {
        return "16.003";
    }

    public static String getGeneralJavaVersion() {
        return System.getProperty("java.specification.version");
    }

    public static String getSpecificJavaVersion() {
        return System.getProperty("java.version");
    }

    public static File getTemporaryDirectory() throws Exception {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static void guaranteedSleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l2 > System.currentTimeMillis()) {
            Utilities.safeSleep(l2 - System.currentTimeMillis());
        }
    }

    public static void ignore(Throwable throwable) {
        Utilities.ignore(throwable.getMessage(), throwable);
    }

    public static void ignore(String string, Throwable throwable) {
        Utilities.println("Ignored Exception: " + string + "\n" + Utilities.stackTrace(throwable));
    }

    public static boolean isFeatureDefined(String string) {
        return Utilities.isFeatureDefined(PTA_PLAYER_FEATURES, string);
    }

    public static boolean isFeatureDefined(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            String string3 = string.trim();
            String[] stringArray = string3.split(PATCH_FILES_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        return false;
    }

    public static boolean isLinux() {
        String string = System.getProperty("os.name", "none").trim().toLowerCase();
        return string.startsWith("linux");
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name", "none").trim().toLowerCase();
        return string.startsWith("win");
    }

    public static void logPrintln() {
        if (Utilities.isFeatureDefined("detailedlog")) {
            Utilities.println();
        }
    }

    public static void logPrintln(String string) {
        if (Utilities.isFeatureDefined("detailedlog")) {
            Utilities.println(string);
        }
    }

    public static String padBefore(int n, String string, int n2) {
        return Utilities.padBefore(String.valueOf(n), string, n2);
    }

    public static String padBefore(String string, String string2, int n) {
        String string3 = string;
        while (string3.length() < n) {
            string3 = string2 + string3;
        }
        return string3;
    }

    public static void print(String string) {
        System.out.print(string);
        buffer.append(string);
    }

    public static void print(Throwable throwable) {
        Utilities.println(throwable.getMessage());
        Utilities.println(Utilities.stackTrace(throwable));
    }

    public static void println() {
        System.out.println();
        buffer.append('\n');
    }

    public static void println(String string) {
        System.out.println(string);
        buffer.append(string);
        buffer.append('\n');
    }

    public static void printClassLoaderContext(ClassLoader classLoader, Class clazz) {
        ClassLoader classLoader2;
        Utilities.println("starting loader = " + classLoader);
        for (classLoader2 = classLoader.getParent(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            Utilities.println("  ==> " + classLoader2);
        }
        ClassLoader classLoader3 = clazz.getClassLoader();
        if (classLoader != classLoader3) {
            Utilities.println("mine = " + classLoader3);
            for (classLoader2 = classLoader3.getParent(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                Utilities.println("  ==> " + classLoader2);
            }
        }
        Policy policy = Policy.getPolicy();
        Utilities.println("policy = " + policy);
        SecurityManager securityManager = System.getSecurityManager();
        Utilities.println("securityManager = " + securityManager);
        Utilities.println("securityManager.getSecurityContext() = " + securityManager.getSecurityContext());
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        Utilities.println("protectionDomain = " + protectionDomain);
    }

    public static void printSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            Utilities.println(string + " = [ " + string2 + " ]");
        }
    }

    public static byte[] readBytes(String string) throws Exception {
        return Utilities.readBytes(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws Exception {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byArray = Utilities.readBytes(fileInputStream);
        }
        catch (Throwable throwable) {
            Utilities.safeClose(fileInputStream);
            throw throwable;
        }
        Utilities.safeClose(fileInputStream);
        return byArray;
    }

    public static byte[] readBytes(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Utilities.copy(inputStream, byteArrayOutputStream, false);
        return byteArrayOutputStream.toByteArray();
    }

    public static String readString(InputStream inputStream) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[64000];
        int n = 0;
        while (n >= 0) {
            n = inputStreamReader.read(cArray, 0, cArray.length);
            if (n <= 0) continue;
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
    }

    public static String safeEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return string;
        }
    }

    public static void safeSleep(long l) {
        try {
            Utilities.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static File saveBuffer() {
        if (Utilities.isFeatureDefined("savebuffer")) {
            try {
                File file = new File(Utilities.getTemporaryDirectory(), "packet-tracer-skills-assessment-player.txt");
                FileWriter fileWriter = new FileWriter(file, true);
                PrintWriter printWriter = new PrintWriter(fileWriter);
                printWriter.println("Packet Tracer Skills Assessment Player log at " + new Date());
                printWriter.println();
                printWriter.println(buffer);
                printWriter.println("\n\n---------------------------------------\n");
                printWriter.flush();
                printWriter.close();
                buffer.setLength(0);
                return file;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        return null;
    }

    public static void setPtaPlayerFeaturesString(String string) {
        PTA_PLAYER_FEATURES = string;
    }

    public static List simpleSplit(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            arrayList.add(string.substring(n, n2));
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        arrayList.add(string.substring(n));
        return arrayList;
    }

    public static void sleep(long l) throws InterruptedException {
        if (l > 0L) {
            Thread.sleep(l);
        }
    }

    public static String stackTrace(Throwable throwable) {
        return Utilities.toString(throwable);
    }

    public static void swallow(Throwable throwable) {
        Utilities.swallow(throwable.getMessage(), throwable);
    }

    public static void swallow(String string, Throwable throwable) {
        Utilities.println("Swallowed Exception: " + string + "\n" + Utilities.stackTrace(throwable));
    }

    public static String toString(Throwable throwable) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            return stringWriter.toString();
        }
        catch (Throwable throwable2) {
            Utilities.check(throwable2);
            return "Unable to retrieve stack trace";
        }
    }

    public static void warn(String string, String string2) {
        Utilities.warn(null, string, string2);
    }

    public static void warn(Component component, String string, String string2) {
        JOptionPane.showMessageDialog(component, string2, string, 2);
    }

    public static void writeBytes(String string, byte[] byArray) throws Exception {
        Utilities.writeBytes(new File(string), byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(File file, byte[] byArray) throws Exception {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray);
        }
        catch (Throwable throwable) {
            Utilities.safeClose(fileOutputStream);
            throw throwable;
        }
        Utilities.safeClose(fileOutputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < NAMES.length; ++i) {
        }
    }
}

